package com.uog.logbook2023.adapter;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.uog.logbook2023.R;
import com.uog.logbook2023.database.Person;

import java.util.List;


public class PersonAdapter extends RecyclerView.Adapter<PersonAdapter.ViewHolder> {
    public interface ClickListener {
        void onItemClick(int position, View v, long id);
    }
    public void setListener(ClickListener listener){
        this.listener =listener;
    }
    private static ClickListener listener;
    private List<Person> personList;
    public void setPersonList(List<Person> personList){
        this.personList =personList;
    }
    public PersonAdapter(List<Person> personList ){
        this.personList =personList;
    }
    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.person_item, parent, false);
        return new ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        Person person =personList.get(position);
        holder.lblId.setText("ID: "+person.getId());
        holder.lblName.setText("Name: " +person.getName());
        holder.lblAddress.setText("Address: "+ person.getAddress());
        holder.lblPhone.setText("Phone: "+person.getPhone());
        holder.lblAge.setText("Age: "+ person.getAge());
        if(person.getImage() !=null ){
            holder.imageView2.setImageResource(person.getImage());
        }
    }

    @Override
    public int getItemCount() {
        return personList.size();
    }

    public static class ViewHolder extends RecyclerView.ViewHolder{
        TextView lblId;
        TextView lblName;
        TextView lblAddress;
        TextView lblPhone;
        TextView lblAge;
        Button btnRemove, btnEdit, btnImage;//
        ImageView imageView2;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            lblId = itemView.findViewById(R.id.lblId);
            lblName =itemView.findViewById(R.id.lblName);
            lblAddress =itemView.findViewById(R.id.lblAddress);
            lblPhone =itemView.findViewById(R.id.lblPhone);
            lblAge =itemView.findViewById(R.id.lblAge);
            imageView2 =itemView.findViewById(R.id.imageView2);
            btnRemove =itemView.findViewById(R.id.btnRemove);///
            btnRemove.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    listener.onItemClick(getAdapterPosition(), view, R.id.btnRemove);
                }
            });
            btnEdit =itemView.findViewById(R.id.btnEdit);
            btnEdit.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    listener.onItemClick(getAdapterPosition(), view, R.id.btnEdit);
                }
            });//
            btnImage =itemView.findViewById(R.id.btnImage);
            btnImage.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    listener.onItemClick(getAdapterPosition(), view, R.id.btnImage);
                }
            });//
        }
    }
}
