package com.uog.logbook2023;

import androidx.appcompat.app.AppCompatActivity;

import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;

public class ViewImageActivity extends AppCompatActivity {

    private ImageView imageView;
    private Button btnprevious, btnnext;
    private int[] images={R.drawable.img1, R.drawable.img2, R.drawable.img3, R.drawable.img4, R.drawable.img5, R.drawable.img6};
    int index =0;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_view_image);

        imageView =findViewById(R.id.imageView);
        btnprevious =findViewById(R.id.btnprevious);
        btnnext =findViewById(R.id.btnnext);
        imageView.setImageResource(images[index]);

        btnprevious.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if( index > 0 ){
                    imageView.setImageResource(images[--index]);
                }
            }
        });
        btnnext.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if( index < images.length -1 ){
                    imageView.setImageResource(images[++index]);
                }
            }
        });
    }
}