package com.uog.logbook2023;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import com.uog.logbook2023.database.DatabaseHelper;
import com.uog.logbook2023.database.Person;
import com.uog.logbook2023.adapter.PersonAdapter;
import java.util.ArrayList;
import java.util.List;

public class PersonListActivity extends AppCompatActivity {
    private List<Person> personList =new ArrayList<>();
    private DatabaseHelper databaseHelper;
    private PersonAdapter personAdapter;
    public static final int UPDATE_RESULT =123;
    public static final int IMAGE_SELECTION_RESULT =234;
    private Button btnAddNew;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_person_list);


        RecyclerView recyclerView =findViewById(R.id.recyclerView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        databaseHelper =new DatabaseHelper(getBaseContext());
        personAdapter =new PersonAdapter( personList );
        personAdapter.setListener(new PersonAdapter.ClickListener() {
            @Override
            public void onItemClick(int position, View v, long id) {
                if( id == R.id.btnRemove ){

                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            try {
                                Person person =personList.get(position);
                                // remove
                                databaseHelper.delete(person.getId());
                                // list
                                personList =databaseHelper.search("");
                                personAdapter.setPersonList(personList);
                                personAdapter.notifyDataSetChanged();// refresh the data
                            }catch (Exception e){}
                        }
                    });

                }else if( id ==R.id.btnEdit ){
                    Person person =personList.get(position);
                    Intent intent =new Intent(getBaseContext(), PersonEntryActivity.class);
                    intent.putExtra(DatabaseHelper.PERSON_ID, person.getId());
                    intent.putExtra(DatabaseHelper.NAME, person.getName());
                    intent.putExtra(DatabaseHelper.ADDRESS, person.getAddress());
                    intent.putExtra(DatabaseHelper.PHONE, person.getPhone());
                    intent.putExtra(DatabaseHelper.AGE, person.getAge());

                    startActivityForResult(intent, UPDATE_RESULT );

                }else if( id ==R.id.btnImage ){
                    Intent intent =new Intent(getBaseContext(), ImageSelectionListActivity.class);
                    intent.putExtra(ImageSelectionListActivity.SELECTED_PERSON, position);
                    startActivityForResult(intent, IMAGE_SELECTION_RESULT );
                }
            }
        });
        recyclerView.setAdapter(personAdapter);

        btnAddNew =findViewById(R.id.btnAddNew);
        btnAddNew.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                Intent intent =new Intent(getBaseContext(), PersonEntryActivity.class);
                startActivityForResult(intent, UPDATE_RESULT );
            }
        });

        //data read
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    personList =databaseHelper.search("");
                    personAdapter.setPersonList(personList);
                    personAdapter.notifyDataSetChanged();// refresh the data
                } catch (Exception e) { e.printStackTrace(); }
            }
        });
    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if( requestCode == UPDATE_RESULT && resultCode == RESULT_OK ){
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    try {
                        personList =databaseHelper.search("");
                        personAdapter.setPersonList(personList);
                        personAdapter.notifyDataSetChanged();// refresh the data
                    } catch (Exception e) { e.printStackTrace(); }
                }
            });
        }else if( requestCode == IMAGE_SELECTION_RESULT && resultCode == RESULT_OK ){
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    try {
                        Bundle bundle =data.getExtras();
                        if( bundle !=null ){
                            Person person =personList.get(bundle.getInt(ImageSelectionListActivity.SELECTED_PERSON));
                            person.setImage(bundle.getInt(ImageSelectionListActivity.SELECTED_IMAGE));
                            personAdapter.notifyDataSetChanged();
                        }
                    } catch (Exception e) { e.printStackTrace(); }
                }
            });
        }
        super.onActivityResult(requestCode, resultCode, data);
    }
}