package com.uog.logbook2023;

import androidx.appcompat.app.AppCompatActivity;
import android.app.AlertDialog;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import com.uog.logbook2023.database.DatabaseHelper;

public class PersonEntryActivity extends AppCompatActivity {

    private EditText txtName, txtAddress, txtPhone, txtAge;
    private Button btnSave;
    private DatabaseHelper databaseHelper;
    private Integer id;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_person_entry);

        txtName =findViewById(R.id.txtName);
        txtAddress =findViewById(R.id.txtAddress);
        txtPhone =findViewById(R.id.txtPhone);
        txtAge =findViewById(R.id.txtAge);
        btnSave =findViewById(R.id.btnSave);

        databaseHelper =new DatabaseHelper(getBaseContext());
        btnSave.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                long result =0;
                if( id == null) {
                    result = databaseHelper.save(txtName.getText().toString(),
                            txtAddress.getText().toString(),
                            txtPhone.getText().toString(),
                            Integer.parseInt(txtAge.getText().toString()));
                    Intent intent = new Intent();
                    setResult(RESULT_OK, intent);
                    finish();
                }else if( id !=null ){
                    result = databaseHelper.update(id, txtName.getText().toString(),
                            txtAddress.getText().toString(),
                            txtPhone.getText().toString(),
                            Integer.parseInt(txtAge.getText().toString()));

                    Intent intent = new Intent();
                    setResult(RESULT_OK, intent);
                    finish();
                }
                if( result >0 ){
                    Toast.makeText(getBaseContext(), "Data saved to database", Toast.LENGTH_SHORT).show();
//                    new AlertDialog.Builder(getBaseContext()).setTitle("Saved").setMessage("Data saved to database").show();
                }else{
                    Toast.makeText(getBaseContext(), "Data does not save", Toast.LENGTH_SHORT).show();
//                    new AlertDialog.Builder(getBaseContext()).setTitle("Error").setMessage("Data does not save");
                }

            }
        });

        Bundle bundle =getIntent().getExtras();
        if( bundle !=null ){
            id =bundle.getInt(DatabaseHelper.PERSON_ID);
            txtName.setText(bundle.getString(DatabaseHelper.NAME));
            txtAddress.setText(bundle.getString(DatabaseHelper.ADDRESS));
            txtPhone.setText(bundle.getString(DatabaseHelper.PHONE));
            txtAge.setText(bundle.getInt(DatabaseHelper.AGE) +"");
        }
    }
}