package com.uog.logbook2023;

import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import com.uog.logbook2023.adapter.ImageSelectionAdapter;

public class ImageSelectionListActivity extends AppCompatActivity {

    public static final String SELECTED_PERSON ="selectedPerson";
    public static final String SELECTED_IMAGE ="selectedImage";

    private ImageSelectionAdapter adapter;
    int personPosition;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_image_selection_list);

        RecyclerView recyclerView =findViewById(R.id.recyclerView2);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        adapter =new ImageSelectionAdapter( );
        adapter.setListener(new ImageSelectionAdapter.ClickListener() {
            @Override
            public void onItemClick(int position, View v, long id) {
                Intent intent = new Intent();
                intent.putExtra(ImageSelectionListActivity.SELECTED_IMAGE, ImageSelectionAdapter.images[position]);
                intent.putExtra(ImageSelectionListActivity.SELECTED_PERSON, personPosition);
                setResult(RESULT_OK, intent);
                finish();
            }
        });
        recyclerView.setAdapter(adapter);

        Bundle bundle =getIntent().getExtras();
        if( bundle !=null ){
            personPosition =bundle.getInt(ImageSelectionListActivity.SELECTED_PERSON);
        }
    }
}