package com.uog.logbook2023;

import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

public class CalculatorActivity extends AppCompatActivity {

    private Button btn0, btn1, btn2, btn3, btn4, btn5, btn6, btn7, btn8, btn9,
            btndivider, btnmultiply, btnminus, btnplus, btnequal, btnclear;
    private TextView txtnumber;
    private String firstNumber ="";
    private String secondNumber ="";
    private String operator ="";
    private boolean clear =true;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_calculator);

        txtnumber =findViewById(R.id.txtnumber);

        btn0 =findViewById(R.id.btn0);
        btn1 =findViewById(R.id.btn1);
        btn2 =findViewById(R.id.btn2);
        btn3 =findViewById(R.id.btn3);
        btn4 =findViewById(R.id.btn4);
        btn5 =findViewById(R.id.btn5);
        btn6 =findViewById(R.id.btn6);
        btn7 =findViewById(R.id.btn7);
        btn8 =findViewById(R.id.btn8);
        btn9 =findViewById(R.id.btn9);

        btndivider =findViewById(R.id.btndivider);
        btnmultiply =findViewById(R.id.btnmultiply);
        btnminus =findViewById(R.id.btnminus);
        btnplus =findViewById(R.id.btnplus);

        btnequal =findViewById(R.id.btnequal);
        btnclear =findViewById(R.id.btnclear);

        registerActions();
    }

    private void registerActions(){

        btn0.setOnClickListener(new View.OnClickListener() {@Override public void onClick(View v) {addNumber("0");}});
        btn1.setOnClickListener(new View.OnClickListener() {@Override public void onClick(View v) {addNumber("1");}});
        btn2.setOnClickListener(new View.OnClickListener() {@Override public void onClick(View v) {addNumber("2");}});
        btn3.setOnClickListener(new View.OnClickListener() {@Override public void onClick(View v) {addNumber("3");}});
        btn4.setOnClickListener(new View.OnClickListener() {@Override public void onClick(View v) {addNumber("4");}});
        btn5.setOnClickListener(new View.OnClickListener() {@Override public void onClick(View v) {addNumber("5");}});
        btn6.setOnClickListener(new View.OnClickListener() {@Override public void onClick(View v) {addNumber("6");}});
        btn7.setOnClickListener(new View.OnClickListener() {@Override public void onClick(View v) {addNumber("7");}});
        btn8.setOnClickListener(new View.OnClickListener() {@Override public void onClick(View v) {addNumber("8");}});
        btn9.setOnClickListener(new View.OnClickListener() {@Override public void onClick(View v) {addNumber("9");}});

        btndivider.setOnClickListener(new View.OnClickListener() {@Override public void onClick(View v) {if( operator.isEmpty() && !firstNumber.isEmpty()) operator ="/";}});
        btnmultiply.setOnClickListener(new View.OnClickListener() {@Override public void onClick(View v) {if( operator.isEmpty() && !firstNumber.isEmpty()) operator ="*";}});
        btnminus.setOnClickListener(new View.OnClickListener() {@Override public void onClick(View v) {if( operator.isEmpty() && !firstNumber.isEmpty()) operator ="-";}});
        btnplus.setOnClickListener(new View.OnClickListener() {@Override public void onClick(View v) {if( operator.isEmpty() && !firstNumber.isEmpty()) operator ="+";}});

        btnequal.setOnClickListener(new View.OnClickListener() {@Override public void onClick(View v) {calculate();}});
        btnclear.setOnClickListener(new View.OnClickListener() {@Override public void onClick(View v) {clear();}});
    }
    private void addNumber(String number){
        if( !clear ) return;

        if( operator.isEmpty() ) {
            firstNumber += firstNumber.isEmpty() && number.equals("0")? "" :number;
            txtnumber.setText(firstNumber);
        }else {
            secondNumber += secondNumber.isEmpty() && number.equals("0")? "" :number;
            txtnumber.setText(secondNumber);
        }
    }

    private void calculate(){
        if( firstNumber.isEmpty() || secondNumber.isEmpty() || operator.isEmpty()) return;


        if( operator.equals("/")){
            float result = Float.parseFloat(firstNumber) / Float.parseFloat(secondNumber);
            txtnumber.setText(String.valueOf(result));

        }if( operator.equals("*")){
            int result = Integer.parseInt(firstNumber) * Integer.parseInt(secondNumber);
            txtnumber.setText(String.valueOf(result));

        }if( operator.equals("-")){
            int result = Integer.parseInt(firstNumber) - Integer.parseInt(secondNumber);
            txtnumber.setText(String.valueOf(result));

        }if( operator.equals("+")){
            int result = Integer.parseInt(firstNumber) + Integer.parseInt(secondNumber);
            txtnumber.setText(String.valueOf(result));

        }

        clear =false;
    }

    private void clear(){
        clear =true;
        txtnumber.setText("0");
        firstNumber ="";
        secondNumber ="";
        operator ="";
    }
}